/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.tabbedPane;

import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCloseableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWCloseableTabComponent
extends JPanel
implements ActionListener {
    private VWCloseableTabbedPane m_tabbedPane = null;
    private JLabel m_tabLabel = null;
    private boolean m_bIsCloseable = true;

    public VWCloseableTabComponent(VWCloseableTabbedPane tabbedPane, String title, Icon icon) {
        this(tabbedPane, title, icon, true);
    }

    public VWCloseableTabComponent(VWCloseableTabbedPane tabbedPane, String title, Icon icon, boolean bIsCloseable) {
        super(new BorderLayout(6, 6));
        this.setBorder(BorderFactory.createEmptyBorder(3, 1, 1, 1));
        this.m_tabbedPane = tabbedPane;
        this.m_bIsCloseable = bIsCloseable;
        this.setOpaque(false);
        this.m_tabLabel = new JLabel(title, icon, 2);
        this.add((Component)this.m_tabLabel, "Before");
        if (bIsCloseable) {
            JButton tabCloseButton = (JButton)VWImageLoader.createToolBarButton("close.gif", VWResource.s_close, false);
            tabCloseButton.addActionListener(this);
            this.add((Component)tabCloseButton, "After");
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_tabbedPane == null) {
            return;
        }
        int nCloseTabIndex = this.m_tabbedPane.getIndexOfTabComponent(this);
        if (nCloseTabIndex != -1) {
            this.m_tabbedPane.fireTabClosedEvent(nCloseTabIndex);
        }
    }

    protected void setIcon(Icon icon) {
        if (this.m_tabLabel != null) {
            this.m_tabLabel.setIcon(icon);
        }
    }

    protected void setTitle(String title) {
        if (this.m_tabLabel != null) {
            this.m_tabLabel.setText(title);
        }
    }

    protected boolean isCloseable() {
        return this.m_bIsCloseable;
    }
}

